	.msfirst
PIA_A	equ	$F000
CON_A	equ	$F001
PIA_B	equ	$F002
CON_B	equ	$F003

ACIA_ATXM	equ	$F004
ACIA_ARCX	equ	ACIA_ATXM
ACIA_ASTS	equ	$F005
ACIA_ARES	equ	ACIA_ASTS
ACIA_ACMD	equ	$F006
ACIA_ACTL	equ	$F007


	ORG	$F800

MAIN:	LDS	$007F		; RESET STACK POINTER

; initialize ACIA
	STA	ACIA_ARES	; SOFT RESET
	LDA	#$0B		; SET SPECIFIC MODES AND FUNCTIONS
	STA	ACIA_ACMD
	LDA	#$1E		; 8-N-1, 9600 BPS
	STA	ACIA_ACTL

SCREAM:
	LDA	ACIA_ASTS
	ANDA	#$10		; TXM DATA REGISTER EMPTY?
	BEQ	SCREAM		; 1=EMPTY, 0=NOT EMPTY

	LDA	#'0'		; LOAD ASCII '0' CHARACTER TO TRANSMIT
	STA	ACIA_ATXM	; SEND TO TRANSMITTER
	BRA	SCREAM		; DO AGAIN FOREVER




	JSR	INITPIA		; INITIALIZE PIA

	LDAA	#$00

	JMP	CONTRL		; GO MAIN LOOP


;MINIBUG FOR N8VEM 6809 HOST PROCESSOR

; INPUT ONE CHAR INTO A-REGISTER
INCH:
	JSR	INCHARRDY	; IS INPUT CHARACTER WAITING?
	BPL	INCH		; NO, TRY AGAIN

	JSR	INCHAR		; YES? GET INPUT CHARACTER
	JMP	OUTCH		; ECHO CHAR


; INPUT HEX CHAR
INHEX:
	BSR	INCH
	CMPA	#$30
	BMI	C1		; NOT HEX
	CMPA	#$39
	BLE	IN1HG
	CMPA	#$41
	BMI	C1		; NOT HEX
	CMPA	#$46
	BGT	C1		; NOT HEX
	SUBA	#$07
IN1HG:
	RTS

LOAD:
;	LDAA	#$D1		; TURN READER ON
;	STAA	ACIACS
;	LDAA	#@21
;	BSR	OUTCH

LOAD3:
	BSR	INCH
	CMPA	#'S'
	BNE	LOAD3		; FIRST CHAR NOT (S)
	BSR	INCH		; READ CHAR
	CMPA	#'9'
	BEQ	LOAD21
	CMPA	#'1'
	BNE	LOAD3		; SECOND CHAR NOT (1)
	CLR	CKSM		; ZERO CHECKSUM
	BSR	BYTE		; READ BYTE
	SUBA	#$02		
	STAA	BYTECT		; BYTE COUNT
; BUILD ADDRESS
	BSR	BADDR
; STORE DATA
LOAD11:
	BSR	BYTE
	DEC	BYTECT
	BEQ	LOAD15		; ZERO BYTE COUNT
	STAA,X			; STORE DATA
	INX
	BRA	LOAD11

LOAD15:
	INC	CKSM
	BEQ	LOAD3
LOAD19:
	LDAA	#'?'
	BSR	OUTCH
LOAD21:
;	LDAA	#$B1		; TURN READER OFF
;	STAA	ACIACS
;	LDAA	#@23
;	BSR	OUTCH
C1	JMP	CONTRL
	
; BUILD ADDRESS
BADDR:
	BSR	BYTE		; READ 2 FRAMES
	STAA	XHI
	BSR	BYTE
	STAA	XLOW
	LDX	XHI		; (X) ADDRESS WE BUILT
	RTS

; INPUT BYTE (TWO FRAMES)
BYTE:
	BSR	INHEX		; GET HEX CHAR
	ASLA
	ASLA
	ASLA
	ASLA
	TAB
	BSR	INHEX
	ANDA	#$0F		; MASK TO 4 BITS
	ABA
	TAB
	ADDB	CKSM
	STAB	CKSM
	RTS

; CHANGE MEMORY(M AAAA DD NN)
CHANGE:
	BSR	BADDR		; BUILD ADDRESS
	BSR	OUTS		; PRINT SPACE
	BSR	OUT2HS
	BSR	BYTE
	DEX
	STAA,X
	CMPA,X
	BNE	LOAD19		; MEMORY DID NOT CHANGE
	BRA	CONTRL


OUTHL:
	LSRA			; OUT HEX LEFT BCD DIGIT
	LSRA			;
	LSRA			;
	LSRA			;

OUTHR:
	ANDA	#$0F		; OUT HEC RIGHT DIGIT
	ADDA	#$30		;
	CMPA	#$39
	BLS	OUTCH
	ADDA	#$07

; OUTPUT ONE CHARACTER
OUTCH:
	PSHS	B		; SAVE B-REG (COUNTER)
	JSR	OUTCHAR
OUTCH1:
	JSR	OUTCHARACK	; WAS OUTPUT CHARACTER ACKNOWLEDGED?
	BPL	OUTCH1		; NO, TRY AGAIN

	LDAB	PIA_B		; RESET BIT 7 CRA WITH OUTPUT REGISTER READ
	PULS	B		; RESTORE B-REG
	RTS

OUT2H:
	LDAA	0,X		; OUTPUT 2 HEX CHAR
	BSR	OUTHL		; OUT LEFT HEX CHAR
	LDAA	0,X		;
	BSR	OUTHR		; OUT RIGHT HEX CHAR
	INX
	RTS

OUT2HS:
	BSR	OUT2H		; OUTPUT 2 HEX CHAR + SPACE
OUTS:
	LDAA	#$20		; SPACE
	BRA	OUTCH		; (BSR & RTS)

; PRINT CONTENTS OF STACK

PRINT:
;	TSX
;	STX	SP		; SAVE STACK POINTER
	STS	SP
	LDX	SP
	LDAB	#$09
PRINT2:
	BSR	OUT2HS		; OUT 2 HEX & SPACE
	DECB
	BNE	PRINT2		; DONE? IF NO DO MORE
	JMP	CONTRL		; DONE? IF YES RETURN TO MAIN LOOP


CONTRL:

;	LDAA	#$B1		; SET SYSTEM PARAMETERS
;	STAA	ACIACS
;	LDS	#STACK

LOOP2:
	JSR	INCHARRDY	; IS INPUT CHARACTER WAITING?
	BPL	LOOP2		; NO, TRY AGAIN

	JSR	INCHAR		; YES? GET INPUT CHARACTER

	PSHS	A		; STORE THE CURRENT CHARACTER
	LDAA	#$0D		; CARRIAGE RETURN
	BSR	OUTCH		; OUTPUT CHARACTER
	LDAA	#$0A		; LINE FEED
	BSR	OUTCH		; OUTPUT CHARACTER
	LDAA	#'>'		; CARRIAGE RETURN
	BSR	OUTCH		; OUTPUT CHARACTER
	PULS	A		; RETRIEVE THE CURRENT CHARACTER	
	PSHS	A
	BSR	OUTCH		; OUTPUT CHARACTER
	LDAA	#' '		; SPACE	
	BSR	OUTCH		; OUTPUT CHARACTER

	PULS	A		; RETRIEVE THE CURRENT CHARACTER	

	CMPA	#'L'
	BNE	LOOP3
	JMP	LOAD		

LOOP3:
	CMPA	#'M'
	BEQ	CHANGE

	CMPA	#'P'
	BEQ	PRINT

	CMPA	#'X'
	BEQ	EXIT

	CMPA	#'G'
	BEQ	GO

	BRA	CONTRL		; RECEIVE NEXT CHARACTER	


EXIT:
	LDAA	#'E'		; FIRST CHARACTER
	BSR	OUTCH		; OUTPUT CHARACTER
	LDAA	#'X'		; SECOND CHARACTER
	BSR	OUTCH		; OUTPUT CHARACTER
	LDAA	#'I'		; THIRD CHARACTER
	BSR	OUTCH		; OUTPUT CHARACTER
	LDAA	#'T'		; FOURTH CHARACTER	
	BSR	OUTCH
	BRA	CONTRL

GO:
	JSR	BADDR		; GET ADDRESS
	BSR	OUTS		; PRINT SPACE
	LDX	XHI		; LOAD X WITH ADDRESS
	JMP	$0000,X		; JUMP TO ADDRESS



INCHARRDY:
	TST	CON_A		; IS BYTE READY (CA1 TRANSITION)
	RTS

INCHAR:
	LDAA	PIA_A		; READ FROM PORT A WITH CA2 STROBES
	RTS

OUTCHAR:
	STAA	PIA_B		; WRITE TO PORT B WITH CB2 STROBES
	LDAA	PIA_B		; RESET BIT 7 CRB
	RTS

OUTCHARACK:
	TST	CON_B		; IS BYTE READY (CB1 TRANSITION)
	RTS			

INITPIA:
	LDAA	#$00		; CLEAR ACCUMULATOR
	STAA	CON_A		; SET DATA DIRECTION REGISTER A
	STAA	CON_B		; SET DATA DIRECTION REGISTER B
	STAA	PIA_A		; ESTABLISH PA0-PA7 AS INPUTS
	LDAA	#%00101110	; SELECT ORA; SET MODE
;	LDAA	#%00110110	; SELECT ORA; SET MODE (BLOCK INPUT, CA2 LOW)
	STAA	CON_A		; CONTROL FOR "A" SIDE
	LDAA	#$FF		; ESTABLISH PB0-PB7 AS OUTPUTS
	STAA	PIA_B
	LDAA	#%00101110	; SELECT ORB; SET MODE
	STAA	CON_B		; CONTROL FOR "B" SIDE
	RTS

; DATA
STACK	EQU	$0100		; STACK POINTER
; REGISTERS FOR GO
;	FCB	$00		; CONDITION CODES
;	FCB	$00		; B ACCUMULATOR
;	FCB	$00		; A
;	FCB	$00		; X-HIGH
;	FCB	$00		; X-LOW
;	FCB	$00		; P-HIGH
;	FCB	$00		; P-LOW
SP	EQU	$0108		; S-HIGH
;	FCB	$00		; S-LOW
	
; END REGISTERS FOR GO
CKSM	EQU	$010A		; CHECKSUM
BYTECT	EQU	$010B		; BYTE COUNT
XHI	EQU	$010C		; XREG HIGH
XLOW	EQU	$010D		; XREG LOW



	ORG	$FFFE		; SET RESET VECTOR TO MAIN PROGRAM
RESETV	FCW	MAIN

	END
